
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: An artists desk o stuff NB 1 unit = 1m
// Date: 6/8/97
// Auth: Anton Delprado
// NOTE: If you want to use this file in whole or in part you MUST receive my permission.
// My e-mail address is delprado@tig.com.au. You may also contact me for any other reason about
// this source file or the rendered file.

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "glass.inc"	// Glass finish & textures

//ja das ist wood
#declare Dez_Dark_Wood = pigment {
  wood
  turbulence .05
  color_map {
    [.65 color rgb <.43*1.5,.24*1.5,.05*1.5>]
    [.8 color rgb <.4+.1,.33+.1,.06+.1>]
    [1  color rgb <.4+.1,.06+.1,.06+.1>]
  }
  scale .01
  rotate y*90
  rotate z*1.2
  translate <0,.75,-.675>
  warp {
    black_hole <1.4,.75,-.718>,.05
    strength 1.5
    inverse
  }
}
#declare Dez_Pallet_Wood = pigment {
  agate
  agate_turb .5
  color_map {
    [0 color rgb <.6,.45,.45>]
    [.4 color rgb <.8,.7,.3>]
    [1 color rgb <.85,.75,.2>]
  }
  rotate y*90
  scale .02
}
#declare Dez_Light_Wood = pigment {Yellow}

//i think you do need one of these, duh
camera {
  location <1.9,1.05,-.8>
  look_at   <0.5,.75,0>
}

light_source {<0,0,0>                          //sun
  colour White
  translate <.5,7,5>
}
light_source {<.75,2,-2> colour rgb <1*.1,1*.1,.75*.1> shadowless} //light so you can see
                                              //everything but it looks like its from the sun
//Skirting board
union {
  box {<-100,0,0>,<100,.05,-.01>}
  box {<-2,0,-100>,<-1.99,.05,100>}
  pigment {White}
  finish {ambient .3}
}

//floor & ceilling
plane {y,0
  pigment {Orange}
  finish {ambient .3}
}
difference {
  plane {-y,-2}
  plane {-z,0}
  pigment {White}
  finish {ambient .3}
}

//walls & windows, NB these are plane so they look pretty stupid from outside
difference {
  plane {-z,0}
  plane {-z,-.05}
  box {<.1,1.05,-10>,<.7,1.75,10>}
  box {<.8,1.05,-10>,<1.4,1.75,10>}
  pigment {
    brick pigment {Gray}, pigment {rgb <.8,.1,.05>}
    brick_size <.2,.08,100>
    mortar .01
  }
  finish {ambient .3}
}
difference {
  plane {x,-2}
  plane {-z,0}
  pigment {
    brick pigment {Gray}, pigment {rgb <.8,.1,.05>}
    brick_size <100,.08,.2>
    mortar .02
  }
  finish {ambient .25}
}
union {
  cylinder {<.1,1.05,0>,<.7,1.05,0>,.01}
  cylinder {<.1,1.05,0>,<.1,1.75,0>,.01}
  cylinder {<.7,1.05,0>,<.7,1.75,0>,.01}
  cylinder {<.1,1.75,0>,<.7,1.75,0>,.01}
  cylinder {<.8,1.05,0>,<1.4,1.05,0>,.01}
  cylinder {<.8,1.05,0>,<.8,1.75,0>,.01}
  cylinder {<1.4,1.05,0>,<1.4,1.75,0>,.01}
  cylinder {<.8,1.75,0>,<1.4,1.75,0>,.01}
  cylinder {<.1,1.05,.05>,<.7,1.05,.05>,.01}
  cylinder {<.1,1.05,.05>,<.1,1.75,.05>,.01}
  cylinder {<.7,1.05,.05>,<.7,1.75,.05>,.01}
  cylinder {<.1,1.75,.05>,<.7,1.75,.05>,.01}
  cylinder {<.8,1.05,.05>,<1.4,1.05,.05>,.01}
  cylinder {<.8,1.05,.05>,<.8,1.75,.05>,.01}
  cylinder {<1.4,1.05,.05>,<1.4,1.75,.05>,.01}
  cylinder {<.8,1.75,.05>,<1.4,1.75,.05>,.01}
  box {<.1,1.05,0>,<.7,1.06,.05>}
  box {<.1,1.75,0>,<.7,1.74,.05>}
  box {<.1,1.05,0>,<.11,1.75,.05>}
  box {<.7,1.05,0>,<.69,1.75,.05>}
  box {<.8,1.05,0>,<1.4,1.06,.05>}
  box {<.8,1.75,0>,<1.4,1.74,.05>}
  box {<.8,1.05,0>,<.81,1.75,.05>}
  box {<1.4,1.05,0>,<1.39,1.75,.05>}
  difference {
    box {<.06,1.01,.06>,<.73,1.79,-.01>}
    box {<.1,1.05,-1>,<.7,1.75,1>}
  }
  difference {
    box {<.77,1.01,.06>,<1.44,1.79,-.01>}
    box {<.8,1.05,-1>,<1.4,1.75,1>}
  }
  pigment {color Brown}
}

//Dust so you can 'see' the light, NB also increases rendering time _alot_.
box { -1, 1
  pigment { colour rgbt <1, 1, 1, 1> }
  halo {
    dust
    dust_type 1
    box_mapping
    constant
    turbulence .8
    colour_map {
      [ 0 color rgbt <1, 1, 1, 1> ]
      [ 1 color rgbt <1, 1, 1, .85> ]
    }
    samples 20
  }
  hollow
  translate <1,1,-1>
}

//Table, pretty self explanitary
union {
  box {<0,.7,-.605>,<1.5,.75,-.75>
    pigment {Dez_Dark_Wood}
  }
  box {<0,.7,-.6>,<1.5,.75,-.455>
    pigment {Dez_Dark_Wood
      translate <-1,0,.15>
    }
  }
  box {<0,.7,-.305>,<1.5,.75,-.45>
    pigment {Dez_Dark_Wood
      translate <-2,0,.3>
    }
  }
  box {<0,.7,-.3>,<1.5,.75,-.155>
    pigment {Dez_Dark_Wood
      translate <-3,0,.45>
    }
  }
  box {<0,.7,0>,<1.5,.75,-.15>
    pigment {Dez_Dark_Wood
      translate <-4,0,.6>
    }
  }
  box {<0,.7,0>,<.05,0,-.05>
    pigment {Dez_Dark_Wood rotate <90,0,90>}
  }
  box {<1.5,.7,0>,<1.45,0,-.05>
    pigment {Dez_Dark_Wood rotate <90,0,90> translate <1.5,1,0>}
  }
  box {<0,.7,-.7>,<.05,0,-.75>
    pigment {Dez_Dark_Wood rotate <90,0,90> translate <0,2,-.7>}
  }
  box {<1.5,.7,-.7>,<1.45,0,-.75>
    pigment {Dez_Dark_Wood rotate <90,0,90> translate <1.5,3,-.7>}
  }
  finish {ambient .3}
}

//paint brush vase. to put you brushes in
lathe {
  cubic_spline
  16,
  <0,0>,<0,0>,<.2,0>,<.3,.2>,
  <.3,.4>,<.15,.5>,<.15,.6>,<.25,.7>,
  <.24,.7>,<.14,.6>,<.14,.5>,<.29,.4>,
  <.29,.2>,<.1,.05>,<0,.05>,<0,.05>
  pigment {
    gradient y
    turbulence .75
    pigment_map {
      [0 color rgb <1,0,1>]
      [1 color rgb <1,0,0>]
    }
    scale .05
  }
  finish {ambient .3}
  scale .5
  translate <.2,.75,-.18>
}

//statuette, for checking human proportions
union {
  cylinder {<0,0,0>,<0,.2,0>,.002
    pigment {colour Gray70}
    finish {specular .9 roughness .1 reflection .25 metallic ambient .3}
  }
  cylinder {<0,0,0>,<0,.0075,0>,.035}
 //torso
  union {
    difference {
      cone {<0,0,0>,.023,<0,-.03,0>,.016}
      plane {z,0}
    }
    difference {
      cone {<0,0,0>,.023,<0,-.03,0>,.016}
      plane {-z,0}
      scale <1,1,5/4>
    }
    difference {
      superellipsoid {<1,.5> rotate x*90}
      plane {z,0}
      scale <.023,.02,.016>
    }
    difference {
      superellipsoid {<1,.5> rotate x*90}
      plane {-z,0}
      scale <.023,.02,.02>
    }
    translate y*.26
  }
  sphere {<0,.22,0>,.013}
  difference {
    sphere {<0,.095,0>,.019 scale <1,2,1>}
    plane {y,.18}
    plane {-y,-.215}
  }
 //legs & feet
  sphere {<.016,.173,0>,.008}
  sphere {<-.016,.173,0>,.008}
  difference {
    sphere {<.016,0,0>,.01 scale <1,8,1> translate y*.15}
    plane {y,.11}
    plane {-y,-.17}
  }
  difference {
    sphere {<-.016,0,0>,.01 scale <1,8,1> translate y*.15}
    plane {y,.11}
    plane {-y,-.17}
  }
  sphere {<.016,.108,0>,.006}
  sphere {<-.016,.108,0>,.006}
  difference {
    sphere {<.016,0,0>,.008 scale <1,8,1> translate y*.08}
    plane {y,.04}
    plane {-y,-.106}
  }
  difference {
    sphere {<-.016,0,0>,.008 scale <1,8,1> translate y*.08}
    plane {y,.04}
    plane {-y,-.106}
  }
  sphere {<.016,.038,0>,.005}
  sphere {<-.016,.038,0>,.005}
  difference {
    sphere {<0,0,0>,1}
    plane {-z,0}
    plane {y,0}
    scale <.009,.007,.04>
    translate <.016,.03,.01>
  }
  difference {
    sphere {<0,0,0>,1}
    plane {-z,0}
    plane {y,0}
    scale <.009,.007,.04>
    translate <-.016,.03,.01>
  }
 //arms
  sphere {<.032,.26,0>,.008}
  sphere {<-.032,.26,0>,.008}
  difference {
    sphere {<.032,0,0>,.008 scale <1,8,1> translate y*.24}
    plane {y,.21}
    plane {-y,-.254}
  }
  difference {
    sphere {<-.032,0,0>,.008 scale <1,8,1> translate y*.24}
    plane {y,.21}
    plane {-y,-.254}
  }
  sphere {<.032,.207,0>,.006}
  sphere {<-.032,.207,0>,.006}
  difference {
    sphere {<.032,0,0>,.006 scale <1,8,1> translate y*.19}
    plane {y,.164}
    plane {-y,-.204}
  }
  difference {
    sphere {<-.032,0,0>,.006 scale <1,8,1> translate y*.19}
    plane {y,.164}
    plane {-y,-.204}
  }
  sphere {<.032,.162,0>,.004}
  sphere {<-.032,.162,0>,.004}
  difference {
    sphere {<.028,0,0>,.006 scale <1,2,1> translate y*.162}
    plane {x,.031}
  }
  difference {
    sphere {<-.028,0,0>,.006 scale <1,2,1> translate y*.162}
    plane {-x,.031}
  }
 //neck & head
  sphere {<0,.275,0>,.009}
  intersection {
    union {
      difference {
        sphere {<0,0,0>,.015}
        plane {y,0}
      }
      cone {<0,0,0>,.015,<0,-.035,0>,.009}
    }
    plane {<0,-.01,-1>,.012 rotate y*30}
    plane {<0,-.01,-1>,.012 rotate y*-30}
    translate y*.31
  }
  pigment {Dez_Light_Wood rotate x*90 scale .35} finish {ambient .3}
  translate <.8,.75,-.15>
}

//glass of water eungh! wash dem brushes
difference {
  cylinder {<1.2,.75,-.16>,<1.2,.9,-.16>,.03}
  cylinder {<1.2,.7575, -.16>,<1.2,1,-.16>,.027}
  pigment {color rgbt <1,1,1,.8>}
  finish {specular 1 roughness 0.001 ambient .3 diffuse 0 refraction 1 reflection 0.1 ior 1.5}
}
cylinder {<1.2,.7575,-.16>,<1.2,.85,-.16>,.027 pigment {colour rgbt <.75,.15,1,.3>} finish {ambient .3} normal {bumps 0.5 scale .8}}
cylinder {<1.2,.8275,-.16>,<1.175,.97,-.16>,.003 pigment {color Gray10} finish {reflection .3 ambient .3}}

//pallet. put all your lovely colours on it
union {
  difference {
    cylinder {<0,0,0>,<0,.005,0>,.1}
    cylinder {<0,-1,-2/30>,<0,1,-2/30>,1/50}
    pigment {Dez_Pallet_Wood}
    finish {ambient .3}
  }
  sphere {<-1/sqrt(300),0.01,-1/30>,1/50
    pigment {color Red}
    finish {phong .8}
    scale <1,.5,1>
  }
  sphere {<-1/sqrt(300),0.01,1/30>,1/50
    pigment {color Yellow}
    finish {phong .8}
    scale <1,.5,1>
  }
  sphere {<0,0.005,2/30>,1/50
    pigment {color Blue}
    finish {phong .8}
    scale <1,.5,1>
  }
  sphere {<1/sqrt(300),0.01,1/30>,1/50
    pigment {color White}
    finish {phong .8}
    scale <1,.5,1>
  }
  sphere {<1/sqrt(300),0.01,-1/30>,1/50
    pigment {color Black}
    finish {phong .8}
    scale <1,.5,1>
  }
  scale <1,1,1.5>
  translate <.9,.75,-.5>
}

//picture. ah finished art
box {<1.1,.75,-.4>,<1.31,.7501,-.69>
  pigment {
    image_map {tga "image.tga"}
    rotate x*90
    scale <.21,1,.29>
    translate <1.1,0,-.4>
  }
}

//paint. now wheres the cap?

difference {
  quartic {<0,0,0,0,0,
           0,0,0,0,1,
           0,0,0,0,0,
           0,0,0,0,0,
           0,0,0,1,0,
           0,0,0,0,0,
           0,0,-1,0,0>
  }
  plane {z,-1}
  plane {-z,.1}
  rotate z*90
  pigment {color rgb <1,.8,.8>}
  scale <.025,.025,.1>
  translate <1.4,.76,-.35>
}
sphere {0,1 scale <.025,.025,.01> pigment {color rgb <1,.5,.5>} translate <1.4,.76,-.45>}
cylinder {0,<0,0,-.02>,.005 pigment {color rgb <1,.5,.5>} translate <1.4,.76,-.45>}
cylinder {<0,0,.02>,<0,0,-.021>,.003 pigment {color Red} finish {ambient .2} translate <1.4,.76,-.45>}
union {
  sphere {0,.025} //200/399,.1}
  sphere {<.025,0,0>,.01} //25/49,.1}
  sphere {<-.015,0,-.02>,.01} //25/49,.1}
  scale <1,.1,1>
  translate <1.4,.75,-.47>
  pigment {color Red}
  finish {ambient .2}
}

//camera. weell some artists use them
union {
  box {<-.06,0,-.03>,<.06,.07,.03> pigment {color Gray75}}
  difference {
    box {<-.06,.07,-.03>,<.06,.08,.03>}
    plane {y,0 rotate z*-20 translate <.03,.08,0> inverse}
    plane {y,0 rotate z*20 translate <-.03,.08,0> inverse}
    pigment {color Gray20}
  }
  difference {
    cylinder {<0,.04,0>,<0,.04,-.07>,.025}
    cylinder {<0,.04,-1>,<0,.04,1>,.02}
    pigment {color Gray25}
  }
  sphere {0,.02
    pigment {color rgbt <1,1,1,.7>}
    finish {phong .6}
    scale <1,1,.2>
    translate <0,.04,-.06>
  }
  rotate y*-20
  translate <.25,.75,-.525>
}

//hand model. for the proportions of a human hand
union {
  //Index
  blob {
    threshold .25
    cylinder {<0,-2.5,0>,<0,2,0>,1,1}
    cylinder {0,<0,1.4,0>,.9,.9 rotate z*30 translate y*2.5}
    cylinder {0,<0,1.5,0>,.85,.85 rotate z*15 translate y*2 rotate z*30 translate y*2.5}
    scale <1,.85,1>
    rotate y*-2.5
    translate x*-.25
  }
  //Middle
  blob {
    threshold .25
    cylinder {<0,-3,0>,<0,2.5,0>,1,1}
    cylinder {0,<0,1.9,0>,.9,.9 rotate z*30 translate y*3}
    cylinder {0,<0,1.5,0>,.85,.85 rotate z*15 translate y*2.5 rotate z*30 translate y*3}
    scale <1,.85,1>
    translate z*-1.5
  }
  //Ring
  blob {
    threshold .25
    cylinder {<0,-2.5,0>,<0,2,0>,1,1}
    cylinder {0,<0,1.4,0>,.9,.9 rotate z*30 translate y*2.5}
    cylinder {0,<0,1.5,0>,.85,.85 rotate z*15 translate y*2 rotate z*30 translate y*2.5}
    scale <1,.85,1>
    rotate y*2.5
    translate <-.15,-.5,-3>
  }
  //Pinkie
  blob {
    threshold .25
    cylinder {<0,-2,0>,<0,1.5,0>,.85,.85}
    cylinder {0,<0,1.4,0>,.75,.75 rotate z*30 translate y*2}
    cylinder {0,<0,1.5,0>,.7,.7 rotate z*15 translate y*2 rotate z*30 translate y*2}
    scale <1,.85,1>
    rotate y*10
    translate <-.5,-1.5,-4.5>
  }
  //Palm
  blob {
    threshold .25
    sphere {0,1,1 scale <.75,2,2> translate <-.8,-1,-1>}
    sphere {0,1,1 scale <1,3,3.75> rotate x*-20 translate <-.5,-1.9,-2.15> rotate z*-10 translate x*.2}
    sphere {0,1,1 scale <2,6,4.15> translate <0,-4,-2.15> rotate z*-10 translate x*.2}
    sphere {0,1,1 scale <1.5,2.5,4.25> rotate x*-30 translate <-1,-5.25,-.5>}
    cylinder {<0,0,0>,<0,2.25,0>,1.5,1.5
      scale <.8,1,.7> rotate z*20 rotate x*15
      translate <-1,-3.5,1.25>
    }
    cylinder {0,<0,2,0>,1.3,1.3
      scale <.8,1,.7> rotate x*-10 translate y*3 rotate z*20 rotate x*15 translate <-1,-3.5,1.25>
    }
  }
  pigment {Dez_Light_Wood}
  finish {ambient .3}
  rotate y*-90
  translate <-2,0>
  scale .015
  translate <1.4,.95,-.16>
}
cylinder {<1.4,.75,-.16>,<1.4,.76,-.16>,.045
  pigment {Dez_Light_Wood}
  finish {ambient .3}
}
cylinder {<1.4,.75,-.16>,<1.4,.95,-.16>,.007
  pigment {colour Gray70}
  finish {specular .9 roughness .1 reflection .25 metallic ambient .3}
}

sky_sphere {pigment{Blue_Sky3}}
